/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.NetworkEdge;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;

public class PipeItem
implements IPipeItem {
    public static final ResourceLocation TYPE = new ResourceLocation("prettypipes", "pipe_item");
    public ItemStack stack;
    public float speed;
    public float x;
    public float y;
    public float z;
    public float lastX;
    public float lastY;
    public float lastZ;
    protected List<BlockPos> path;
    protected BlockPos startInventory;
    protected BlockPos destInventory;
    protected BlockPos currGoalPos;
    protected int currentTile;
    protected boolean retryOnObstruction;
    protected long lastWorldTick;
    protected ResourceLocation type;

    public PipeItem(ResourceLocation type, ItemStack stack, float speed) {
        this.type = type;
        this.stack = stack;
        this.speed = speed;
    }

    public PipeItem(ItemStack stack, float speed) {
        this(TYPE, stack, speed);
    }

    public PipeItem(ResourceLocation type, CompoundTag nbt) {
        this.type = type;
        this.path = new ArrayList<BlockPos>();
        this.deserializeNBT(nbt);
    }

    @Override
    public ItemStack getContent() {
        return this.stack;
    }

    @Override
    public void setDestination(BlockPos startInventory, BlockPos destInventory, GraphPath<BlockPos, NetworkEdge> path) {
        this.startInventory = startInventory;
        this.destInventory = destInventory;
        this.path = PipeItem.compilePath(path);
        this.currGoalPos = this.getStartPipe();
        this.currentTile = 0;
        if (this.x == 0.0f && this.y == 0.0f && this.z == 0.0f) {
            this.x = Mth.m_14179_((float)0.5f, (float)startInventory.m_123341_(), (float)this.currGoalPos.m_123341_()) + 0.5f;
            this.y = Mth.m_14179_((float)0.5f, (float)startInventory.m_123342_(), (float)this.currGoalPos.m_123342_()) + 0.5f;
            this.z = Mth.m_14179_((float)0.5f, (float)startInventory.m_123343_(), (float)this.currGoalPos.m_123343_()) + 0.5f;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateInPipe(PipeBlockEntity currPipe) {
        long worldTick = currPipe.m_58904_().m_46467_();
        if (this.lastWorldTick == worldTick) {
            return;
        }
        this.lastWorldTick = worldTick;
        float motionLeft = this.speed;
        while (motionLeft > 0.0f) {
            float currSpeed = Math.min(0.25f, motionLeft);
            motionLeft -= currSpeed;
            BlockPos myPos = new BlockPos((double)this.x, (double)this.y, (double)this.z);
            if (!(myPos.equals((Object)currPipe.m_58899_()) || !currPipe.m_58899_().equals((Object)this.getDestPipe()) && myPos.equals((Object)this.startInventory))) {
                currPipe.getItems().remove(this);
                PipeBlockEntity next = this.getNextTile(currPipe, true);
                if (next == null) {
                    if (currPipe.m_58904_().f_46443_) return;
                    if (currPipe.m_58899_().equals((Object)this.getDestPipe())) {
                        this.stack = this.store(currPipe);
                        if (this.stack.m_41619_()) return;
                        this.onPathObstructed(currPipe, true);
                        return;
                    }
                    this.onPathObstructed(currPipe, false);
                    return;
                }
                next.getItems().add(this);
                currPipe = next;
            } else {
                double dist = this.currGoalPos.m_203202_((double)(this.x - 0.5f), (double)(this.y - 0.5f), (double)(this.z - 0.5f));
                if (dist < (double)(currSpeed * currSpeed)) {
                    BlockPos nextPos;
                    PipeBlockEntity next = this.getNextTile(currPipe, false);
                    if (next == null || next == currPipe) {
                        if (!currPipe.m_58899_().equals((Object)this.getDestPipe())) {
                            currPipe.getItems().remove(this);
                            if (currPipe.m_58904_().f_46443_) return;
                            this.onPathObstructed(currPipe, false);
                            return;
                        }
                        nextPos = this.destInventory;
                    } else {
                        nextPos = next.m_58899_();
                    }
                    float tolerance = 0.001f;
                    if (dist >= (double)(tolerance * tolerance)) {
                        Vec3 motion = new Vec3((double)(this.x - this.lastX), (double)(this.y - this.lastY), (double)(this.z - this.lastZ));
                        Vec3 diff = new Vec3((double)((float)nextPos.m_123341_() + 0.5f - this.x), (double)((float)nextPos.m_123342_() + 0.5f - this.y), (double)((float)nextPos.m_123343_() + 0.5f - this.z));
                        if (motion.m_82537_(diff).m_82553_() >= (double)tolerance) {
                            currSpeed = (float)Math.sqrt(dist);
                        } else {
                            this.currGoalPos = nextPos;
                        }
                    } else {
                        this.currGoalPos = nextPos;
                    }
                }
            }
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastZ = this.z;
            Vec3 dist = new Vec3((double)((float)this.currGoalPos.m_123341_() + 0.5f - this.x), (double)((float)this.currGoalPos.m_123342_() + 0.5f - this.y), (double)((float)this.currGoalPos.m_123343_() + 0.5f - this.z));
            dist = dist.m_82541_();
            this.x = (float)((double)this.x + dist.f_82479_ * (double)currSpeed);
            this.y = (float)((double)this.y + dist.f_82480_ * (double)currSpeed);
            this.z = (float)((double)this.z + dist.f_82481_ * (double)currSpeed);
        }
    }

    protected void onPathObstructed(PipeBlockEntity currPipe, boolean tryReturn) {
        if (currPipe.m_58904_().f_46443_) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(currPipe.m_58904_());
        if (tryReturn) {
            if (!this.retryOnObstruction && network.routeItemToLocation(currPipe.m_58899_(), this.destInventory, this.getStartPipe(), this.startInventory, this.stack, speed -> this)) {
                this.retryOnObstruction = true;
                return;
            }
            ItemStack remain = network.routeItem(currPipe.m_58899_(), this.destInventory, this.stack, (stack, speed) -> this, false);
            if (!remain.m_41619_()) {
                this.drop(currPipe.m_58904_(), remain.m_41777_());
            }
        } else {
            this.drop(currPipe.m_58904_(), this.stack);
        }
    }

    @Override
    public void drop(Level world, ItemStack stack) {
        ItemEntity item = new ItemEntity(world, (double)this.x, (double)this.y, (double)this.z, stack.m_41777_());
        item.f_19853_.m_7967_((Entity)item);
    }

    protected ItemStack store(PipeBlockEntity currPipe) {
        Direction dir = Utility.getDirectionFromOffset(this.destInventory, this.getDestPipe());
        IPipeConnectable connectable = currPipe.getPipeConnectable(dir);
        if (connectable != null) {
            return connectable.insertItem(currPipe.m_58899_(), dir, this.stack, false);
        }
        IItemHandler handler = currPipe.getItemHandler(dir);
        if (handler != null) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)this.stack, (boolean)false);
        }
        return this.stack;
    }

    protected PipeBlockEntity getNextTile(PipeBlockEntity currPipe, boolean progress) {
        if (this.path.size() <= this.currentTile + 1) {
            return null;
        }
        BlockPos pos = this.path.get(this.currentTile + 1);
        if (progress) {
            ++this.currentTile;
        }
        PipeNetwork network = PipeNetwork.get(currPipe.m_58904_());
        return network.getPipe(pos);
    }

    protected BlockPos getStartPipe() {
        return this.path.get(0);
    }

    @Override
    public BlockPos getDestPipe() {
        return this.path.get(this.path.size() - 1);
    }

    @Override
    public BlockPos getCurrentPipe() {
        return this.path.get(this.currentTile);
    }

    @Override
    public BlockPos getDestInventory() {
        return this.destInventory;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("type", this.type.toString());
        nbt.m_128365_("stack", (Tag)this.stack.serializeNBT());
        nbt.m_128350_("speed", this.speed);
        nbt.m_128365_("start_inv", (Tag)NbtUtils.m_129224_((BlockPos)this.startInventory));
        nbt.m_128365_("dest_inv", (Tag)NbtUtils.m_129224_((BlockPos)this.destInventory));
        nbt.m_128365_("curr_goal", (Tag)NbtUtils.m_129224_((BlockPos)this.currGoalPos));
        nbt.m_128379_("drop_on_obstruction", this.retryOnObstruction);
        nbt.m_128405_("tile", this.currentTile);
        nbt.m_128350_("x", this.x);
        nbt.m_128350_("y", this.y);
        nbt.m_128350_("z", this.z);
        ListTag list = new ListTag();
        for (BlockPos pos : this.path) {
            list.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        nbt.m_128365_("path", (Tag)list);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack"));
        this.speed = nbt.m_128457_("speed");
        this.startInventory = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("start_inv"));
        this.destInventory = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("dest_inv"));
        this.currGoalPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("curr_goal"));
        this.retryOnObstruction = nbt.m_128471_("drop_on_obstruction");
        this.currentTile = nbt.m_128451_("tile");
        this.x = nbt.m_128457_("x");
        this.y = nbt.m_128457_("y");
        this.z = nbt.m_128457_("z");
        this.path.clear();
        ListTag list = nbt.m_128437_("path", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.path.add(NbtUtils.m_129239_((CompoundTag)list.m_128728_(i)));
        }
    }

    @Override
    public int getItemsOnTheWay(BlockPos goalInv) {
        return this.stack.m_41613_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PipeBlockEntity tile, PoseStack matrixStack, Random random, float partialTicks, int light, int overlay, MultiBufferSource source) {
        matrixStack.m_85837_((double)Mth.m_14179_((float)partialTicks, (float)this.lastX, (float)this.x), (double)Mth.m_14179_((float)partialTicks, (float)this.lastY, (float)this.y), (double)Mth.m_14179_((float)partialTicks, (float)this.lastZ, (float)this.z));
        if (this.stack.m_41720_() instanceof BlockItem) {
            scale = 0.7f;
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85837_(0.0, (double)-0.2f, 0.0);
        } else {
            scale = 0.45f;
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85837_(0.0, (double)-0.1f, 0.0);
        }
        random.setSeed(Item.m_41393_((Item)this.stack.m_41720_()) + this.stack.m_41773_());
        int amount = this.getModelCount();
        for (int i = 0; i < amount; ++i) {
            matrixStack.m_85836_();
            if (amount > 1) {
                matrixStack.m_85837_((double)((random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f), (double)((random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f), (double)((random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f));
            }
            Minecraft.m_91087_().m_91291_().m_174269_(this.stack, ItemTransforms.TransformType.GROUND, light, overlay, matrixStack, source, 0);
            matrixStack.m_85849_();
        }
    }

    public String toString() {
        return "PipeItem{stack=" + this.stack + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", startInventory=" + this.startInventory + ", destInventory=" + this.destInventory + "}";
    }

    protected int getModelCount() {
        int i = 1;
        if (this.stack.m_41613_() > 48) {
            i = 5;
        } else if (this.stack.m_41613_() > 32) {
            i = 4;
        } else if (this.stack.m_41613_() > 16) {
            i = 3;
        } else if (this.stack.m_41613_() > 1) {
            i = 2;
        }
        return i;
    }

    protected static List<BlockPos> compilePath(GraphPath<BlockPos, NetworkEdge> path) {
        Graph<BlockPos, NetworkEdge> graph = path.getGraph();
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        List<BlockPos> nodes = path.getVertexList();
        if (nodes.size() == 1) {
            for (int i = 0; i < 2; ++i) {
                ret.add(nodes.get(0));
            }
            return ret;
        }
        for (int i = 0; i < nodes.size() - 1; ++i) {
            int j2;
            BlockPos first = nodes.get(i);
            BlockPos second = nodes.get(i + 1);
            NetworkEdge edge = graph.getEdge(first, second);
            Consumer<Integer> add = j -> {
                BlockPos pos = edge.pipes.get((int)j);
                if (!ret.contains(pos)) {
                    ret.add(pos);
                }
            };
            if (!graph.getEdgeSource(edge).equals((Object)first)) {
                for (j2 = edge.pipes.size() - 1; j2 >= 0; --j2) {
                    add.accept(j2);
                }
                continue;
            }
            for (j2 = 0; j2 < edge.pipes.size(); ++j2) {
                add.accept(j2);
            }
        }
        return ret;
    }
}

